/********************** Copyright(c)***************************
** Shenzhen Yuejiang Technology Co., Ltd.
**
** http:// www.dobot.cc
**
**------File Info----------------------------------------------
** File name:            Led.cpp
** Latest modified date: 2019-05-15
** Latest version:       V1.0.0
** Description:          SmartKit Led API
**
**------------------------------------------------------------
** Created by:
** Created date:         2019-05-15
** Version:              V1.0.0
** Descriptions:         SmartKit Led API
**
**------------------------------------------------------------
** Modified by:
** Modified date:
** Version:
** Description:
**
*************************************************************/
#include "SmartKit.h"
#include "JoyStick.h"
#include "Led.h"
#include "Button.h"
#include "VoiceRecognition.h"
#include "DobotPixy.h"
#include <SoftwareSerial.h>



JOYSTICK gJoyStick;         /* ҡ */
LED      gLed;              /*  */
BUTTON   gButton;           /*  */
VoiceRecognition gVoiveCN;  /*  */
SoftwareSerial softSerial(SOFTSERIAL_RX_PIN,SOFTSERIAL_TX_PIN); /* Ӣ */
VIS gVIS;                   /* Ӿʶ */

/*************************************************************
** Function name:	  SmartKitInit
** Descriptions:	  SmartKitʼ,ʼҡ
**                                               ָʾ
**                                               ť
**												 Ӣ
**                             ע⣺ӾҪʼ
**									 Ҫʼ
** Input parameters:  no
** Output parameters: no
** Returned value:	  no
*************************************************************/
void SmartKit_Init(void)
{
    Serial.begin(115200);
    Serial.println("======Enter application======");
    Serial.println("======Version: 2.0.1======");
    gJoyStick.Init(JOYSTICK_XPIN,
                   JOYSTICK_YPIN, 
                   JOYSTICK_ZPIN);
	Serial.println("======JoyStick Init======");
    gLed.Init(LED_REDPIN,
              LED_BLUEPIN, 
              LED_GREENPIN);
	Serial.println("======Led Init======");
    gButton.Init(BUTTON_REDPIN,
                 BUTTON_BLUEPIN, 
                 BUTTON_GREENPIN);
	Serial.println("======Button Init======");
    softSerial.begin(9600);
	Serial.println("======VoiveEN Init======");
    Serial.println("======SmartKit Init======");
}

/*************************************************************
** Function name:	  SmartKit_VoiceCNInit
** Descriptions:	  ʼ
**                             ע⣺ӾҪʼ
** Input parameters:  no
** Output parameters: no
** Returned value:	  no
*************************************************************/
void SmartKit_VoiceCNInit(void)
{
	Serial.begin(115200);
    gVoiveCN.init();
	Serial.println("======VoiveCN Init======");
}

/*************************************************************
** Function name:	  SmartKit_ButtonCheckState
** Descriptions:	  鰴״̬
** Input parameters:  color: ɫ
**                           ɴֵBLUE,GREEN,RED
** Output parameters: no
** Returned value:	  ذ״̬UPDOWN
*************************************************************/

int SmartKit_ButtonCheckState(char color)
{
    return gButton.CheckState(color);
}

/*************************************************************
** Function name:	  SmartKit_JoyStickReadXYValue
** Descriptions:	  ȡҡֵ
** Input parameters:  axisϵ,ɴAXISXAXISY
** Output parameters: no
** Returned value:	  ҡ˵ֵ
*************************************************************/

int SmartKit_JoyStickReadXYValue(int axis)
{
    return gJoyStick.ReadXYValue(axis);
}

/*************************************************************
** Function name:	  SmartKit_JoyStickCheckPressState
** Descriptions:	  ҡ˰ѹ״̬
** Input parameters:  no
** Output parameters: no
** Returned value:	  ѹ״̬UP,DOWN
*************************************************************/

int SmartKit_JoyStickCheckPressState(void)
{
    return gJoyStick.CheckPressState();
}

/*************************************************************
** Function name:	  SmartKit_LedCheckStatu
** Descriptions:	  LED״̬
** Input parameters:  color: ledƵɫ
**                           ɴֵBLUE,GREEN,RED
** Output parameters: no
** Returned value:	  led״̬ ONOFF
*************************************************************/

int SmartKit_LedCheckState(char color)
{
    return gLed.CheckState(color);
}

/*************************************************************
** Function name:	  SmartKit_LedTurn
** Descriptions:	  LED
** Input parameters:  color: ledƵɫ
**                           ɴֵBLUE,GREEN,RED
**					  state: ledƵ״̬
**                           ɴֵON,OFF
** Output parameters: no
** Returned value:	  no
*************************************************************/

void SmartKit_LedTurn(char color, int state)
{
    gLed.Turn(color, state);
}

/*************************************************************
** Function name:	  SmartKit_VoiceCNAddCommand
** Descriptions:	  
** Input parameters:  *Voice: Ҫӵָ
**					  num: Ҫӵк
** Output parameters: no
** Returned value:	  no
*************************************************************/

void SmartKit_VoiceCNAddCommand(char *Voice, int num)
{
    gVoiveCN.addCommand(Voice, num);
}

/*************************************************************
** Function name:	  SmartKit_VoiceCNVoiceCheck
** Descriptions:	  
** Input parameters:  num: Ҫ
** Output parameters: no
** Returned value:	  TRUE: ⵽; FALSE: ûм⵽
*************************************************************/

int SmartKit_VoiceCNVoiceCheck(int num)
{
    return gVoiveCN.VoiceCheck(num);
}

/*************************************************************
** Function name:	  SmartKit_VoiceCNStart
** Descriptions:	  ⿪ʼ
** Input parameters:  no
** Output parameters: no
** Returned value:	  no
*************************************************************/

void SmartKit_VoiceCNStart(void)
{
    gVoiveCN.start();
}

/*************************************************************
** Function name:	  SmartKit_VoiceENGVoiceCheck
** Descriptions:	  Ӣ
** Input parameters:  num: Ҫ
** Output parameters: no
** Returned value:	  TRUE: ⵽; FALSE: ûм⵽
*************************************************************/

int SmartKit_VoiceENGVoiceCheck(int num)
{
	static int lastNum = 0;
	int preNum = 0;
	preNum = softSerial.read();
	if (preNum > 0)
	{ 
		lastNum = preNum;
	}
	if (lastNum == num)
	{
		lastNum = 0;
		return TRUE;
	}
	return FALSE;    
}

/*************************************************************
** Function name:	  SmartKit_VoiceENGStart
** Descriptions:	  Ӣ⿪ʼ
** Input parameters:  no
** Output parameters: no
** Returned value:	  no
*************************************************************/

void SmartKit_VoiceENGStart(void)
{
    softSerial.listen();
}

/*************************************************************
** Function name:      Init
** Descriptions:       Ӿʼ
**					   Ĭ̧߶30
**					   ʼ֮ǰҪɫ궨λñ궨
** Input parameters:   no
** Output parameters:  no
** Returned value:     no
*************************************************************/

void SmartKit_VISInit(void)
{
    gVIS.Init();
}

/*************************************************************
** Function name:      SmartKit_VISSetDobotMatrix
** Descriptions:       ûе۱任
** Input parameters:   x1: 1x
**					   y1: 1y
**					   x2: 2x
**					   y2: 2y
**					   x3: 3x
**					   y3: 3y
** Output parameters:  no
** Returned value:     no
*************************************************************/

void SmartKit_VISSetDobotMatrix(float x1, float y1,
                                float x2, float y2,
                                float x3, float y3)
{
    gVIS.SetDobotMatrix(x1, y1, x2, y2, x3, y3);
}

/*************************************************************
** Function name:      SmartKit_VISSetPixyMatrix
** Descriptions:       pixy任
** Input parameters:   x1:		1x
**					   y1:		1y
**					   length1: 1ĳ
**					   weight1: 1Ŀ
**					   x2:		2x
**					   y2:		2y
**					   length2: 2ĳ
**					   weight2: 2Ŀ
**					   x3:		3x
**					   y3:		3y
**					   length3: 3ĳ
**					   weight3: 3Ŀ
** Output parameters:  no
** Returned value:     no
*************************************************************/

void SmartKit_VISSetPixyMatrix(
    float x1, float y1, float length1, float wide1,
    float x2, float y2, float length2, float wide2,
    float x3, float y3, float length3, float wide3)
{
    gVIS.SetPixyMatrix(
        x1, y1, length1, wide1,
        x2, y2, length2, wide2,
        x3, y3, length3, wide3);
}

/*************************************************************
** Function name:      SmartKit_VISSetGrapAreaZ
** Descriptions:       ץȡz
** Input parameters:   z: ץȡ߶
** Output parameters:  no
** Returned value:     no
*************************************************************/

void SmartKit_VISSetGrapAreaZ(float z)
{
    gVIS.SetGrapAreaZ(z);
}

/*************************************************************
** Function name:      SmartKit_VISGetGrapAreaZ
** Descriptions:       ȡץȡz
** Input parameters:   no
** Output parameters:  no
** Returned value:     ץȡ߶
*************************************************************/

float SmartKit_VISGetGrapAreaZ(void)
{
    return gVIS.GetGrapAreaZ();
}

/*************************************************************
** Function name:      SmartKit_VISSetAT
** Descriptions:       ûеӾʶ
** Input parameters:   x:
**					   y:
**					   z:
**					   r: תǶ
** Output parameters:  no
** Returned value:     no
*************************************************************/

void SmartKit_VISSetAT(float x, float y, float z, float r)
{
    gVIS.SetAT(x, y, z, r);
}

/*************************************************************
** Function name:      SmartKit_VISSetColorSignature
** Descriptions:       ɫʶ
** Input parameters:   color: ɫ
**                            ɴֵ:RED,BLUE,YELLOW,GREEN
**					   signature: ʶ
** Output parameters:  no
** Returned value:     TRUE: ɹ; FALSE: ʧ
*************************************************************/

char SmartKit_VISSetColorSignature(char color, char signature)
{
    return gVIS.SetColorSignature(color, signature);
}

/*************************************************************
** Function name:      SmartKit_VISSetBlockTA
** Descriptions:       øɫĿ
** Input parameters:   color: ɫ
**                            ɴֵ:RED,BLUE,YELLOW,GREEN
**					   x: x
**					   y: y
**					   z: z
**					   r: תǶ
** Output parameters:  no
** Returned value:     TRUE: ɹ; FALSE: ʧ
*************************************************************/

char SmartKit_VISSetBlockTA(char color, 
                            float x, 
                            float y, 
                            float z, 
                            float r)
{
    return gVIS.SetBlockTA(color, x, y, z, r);
}

/*************************************************************
** Function name:      SmartKit_VISGetBlockCheckNum
** Descriptions:       ȡӾ⵽Ĳͬɫ
** Input parameters:   color: ɫ
**                            ɴֵ:RED,BLUE,YELLOW,GREEN
** Output parameters:  no
** Returned value:     
*************************************************************/

char SmartKit_VISGetBlockCheckNum(char color)
{
    return gVIS.GetBlockCheckNum(color);
}

/*************************************************************
** Function name:      SmartKit_VISSetBlockPlaceNum
** Descriptions:       
** Input parameters:   color: ɫ
**                            ɴֵ:RED,BLUE,YELLOW,GREEN
**					   placeNum: õ
** Output parameters:  no
** Returned value:     TRUE: ɹ; FALSE: ʧ
*************************************************************/

char SmartKit_VISSetBlockPlaceNum(char color, int placeNum)
{
    return gVIS.SetBlockPlaceNum(color, placeNum);
}

/*************************************************************
** Function name:      SmartKit_VISGetBlockPlaceNum
** Descriptions:       ȡõ
** Input parameters:   color: ɫ
**                            ɴֵ:RED,BLUE,YELLOW,GREEN
** Output parameters:  no
** Returned value:     
*************************************************************/

char SmartKit_VISGetBlockPlaceNum(char color)
{
    return gVIS.GetBlockPlaceNum(color);
}

/*************************************************************
** Function name:      SmartKit_VISSetBlockHeight
** Descriptions:       ߶
** Input parameters:   color: ɫ
**                            ɴֵ:RED,BLUE,YELLOW,GREEN
**					   height: ߶
** Output parameters:  no
** Returned value:     TRUE: ɹ; FALSE: ʧ
*************************************************************/

char SmartKit_VISSetBlockHeight(char color, float height)
{
    return gVIS.SetBlockHeight(color, height);
}

/*************************************************************
** Function name:      SmartKit_VISBlockParmCheckNumClear
** Descriptions:       ĸɫpixy⵽
** Input parameters:   no
** Output parameters:  no
** Returned value:     no
*************************************************************/

void SmartKit_VISBlockParmCheckNumClear(void)
{
    gVIS.BlockParmCheckNumClear();
}

/*************************************************************
** Function name:      SmartKit_VISRun
** Descriptions:       Ӿʶ
** Input parameters:   no
** Output parameters:  no
** Returned value:     TRUE: ;
**					   FALSE: ԭ¼ֿ
**							  1,ûм⵽飬
**							  2,ɫ
*************************************************************/

char SmartKit_VISRun(void)
{
    return gVIS.Run();
}

/*************************************************************
** Function name:      SmartKit_VISSetGrapBlockMark
** Descriptions:       ץȡ
** Input parameters:   mark: ץȡ
** Output parameters:  no
** Returned value:     TRUE: ɹ; FALSE: ʧ
*************************************************************/

int SmartKit_VISSetGrapBlockMark(int mark)
{
    return gVIS.SetGrapBlockMark(mark);
}

/*************************************************************
** Function name:      SmartKit_VISGetGrapBlockMark
** Descriptions:       ȡץȡ
** Input parameters:   no
** Output parameters:  no
** Returned value:     ץȡǣTRUEѾץȡ
                                     FALSEδץȡ
*************************************************************/

int SmartKit_VISGetGrapBlockMark(void)
{
    return gVIS.GetGrapBlockMark();
}

/*************************************************************
** Function name:      SmartKit_VISGrabBlock
** Descriptions:       ץȡ
** Input parameters:   color: ץȡɫ
**                            ɴֵ:RED,BLUE,YELLOW,GREEN
**					   blockNum: ı
**					   r: ץȡתĽǶ
** Output parameters:  no
** Returned value:     TRUE: ɹ; FALSE: ʧ
*************************************************************/

char SmartKit_VISGrabBlock(char color, int blockNum, float r)
{
    return gVIS.GrabBlock(color, blockNum, r);
}

/*************************************************************
** Function name:      SmartKit_VISPlaceBlock
** Descriptions:       
** Input parameters:   color: ɫ
**                            ɴֵ:RED,BLUE,YELLOW,GREEN
** Output parameters:  no
** Returned value:     TRUE: ɹ; FALSE: ʧ
*************************************************************/

char SmartKit_VISPlaceBlock(char color)
{
    return gVIS.PlaceBlock(color);
}

