/****************************************Copyright(c)*****************************************************
**                            Shenzhen Yuejiang Technology Co., LTD.
**
**                                 http://www.dobot.cc
**--------------------------------------------------------------------------------------------------------
** Modify by:           
** Modified date:       2019-06-05
** Version:             V2.0.0
** Descriptions:        Seeed Voice Dobot
**--------------------------------------------------------------------------------------------------------
*********************************************************************************************************/
#include "SmartKit.h"

const char *voiceBuffer[] =
{
    "Turn on the light",                                                              //return 1
    "Turn off the light",                                                             //return 2
    "Play music",                                                                     //return 3
    "Pause",                                                                          //return 4
    "Next",                                                                           //return 5
    "Previous",                                                                       //return 6
    "Up",                                                                             //return 7
    "Down",                                                                           //return 8
    "Turn on the TV",                                                                 //return 9
    "Turn off the TV",                                                                //return 10
    "Increase temperature",                                                           //return 11
    "Decrease temperature",                                                           //return 12
    "What's the time",                                                                //return 13
    "Open the door",                                                                  //return 14
    "Close the door",                                                                 //return 15
    "Left",                                                                           //return 16
    "Right",                                                                          //return 17
    "Stop",                                                                           //return 18
    "Start",                                                                          //return 19
    "Mode 1",                                                                         //return 20
    "Mode 2",                                                                         //return 21
    "Go",                                                                             //return 22
};

void setup()
{
    Serial.begin(115200);
    Dobot_Init();
    SmartKit_Init();
    SmartKit_VoiceENGStart();
    Serial.println("Start...");
}

void loop()
{
    if(SmartKit_VoiceENGVoiceCheck(7) == TRUE)
    {
        Dobot_SetPTPCmd(MOVL_INC,0,0,30,0);                                  //magician moves upward
        Serial.println(voiceBuffer[6]);
     }
     else if(SmartKit_VoiceENGVoiceCheck(8) == TRUE)
     {
        Dobot_SetPTPCmd(MOVL_INC,0,0,-30,0);                                 //magician moves downward
        Serial.println(voiceBuffer[7]);
     }
     else if(SmartKit_VoiceENGVoiceCheck(16) == TRUE)
    {
        Dobot_SetPTPCmd(MOVL_INC,0,30,0,0);                                  //magician turns left
        Serial.println(voiceBuffer[15]);
     }
     else if(SmartKit_VoiceENGVoiceCheck(17) == TRUE)
     {
        Dobot_SetPTPCmd(MOVL_INC,0,-30,0,0);                                 //magician turns right
        Serial.println(voiceBuffer[16]);
     }
     else if(SmartKit_VoiceENGVoiceCheck(18) == TRUE)
    {
        Dobot_SetEndEffectorSuctionCup(false);                               //turn off the air pump
        Serial.println(voiceBuffer[17]);
     }
     else if(SmartKit_VoiceENGVoiceCheck(19) == TRUE)
     {
        Dobot_SetEndEffectorSuctionCup(true);                                //turn on the air pump
        Serial.println(voiceBuffer[18]);
     }
     else if(SmartKit_VoiceENGVoiceCheck(20) == TRUE)
    {
        Dobot_SetPTPCmd(MOVL_INC,30,0,0,0);                                  //magician moves forward
        Serial.println(voiceBuffer[19]);
     }
     else if(SmartKit_VoiceENGVoiceCheck(21) == TRUE)
     {
        Dobot_SetPTPCmd(MOVL_INC,-30,0,0,0);                                 //magician moves backward
        Serial.println(voiceBuffer[20]);
     }
}
